 ; Ŀ
 ;   Span - pan ms using ps or ms points.                                  
 ;   Copyright 2009, 2010 by Rocket Software Ltd.                          
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Wasp - are we in the Model Space Tab, Paper Space, or      
 ;   a viewport in Paper Space?                                            
 ;   Brooks no Arguments.                                                  
 ;   Calls nothing.                                                        
 ;   Returns: 1 - Model space.                                             
 ;            2 - Paper space.                                             
 ;            3 - A Viewport in Paper Space.                               
 ; 
 (DEFUN WASP ()
  (cond ((= (getvar "tilemode") 1) 1)  ; model
        ((= (getvar "cvport") 1) 2)    ; paper space
        (t 3)))                        ; a ps viewport
 ; Ŀ
 ;   Wasp end.                                                             
 ; 

 ; Ŀ
 ;   Span.                                                                 
 ; 
 (DEFUN C:SPAN (/ pa pb cspac)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make a temporary local error handler.                                 
 ; 
  (defun *error* (shk)
   (command "undo" "end")
   (command "undo" "")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   The pan points must be selected from ps, because ps can snap to       
 ;   points in ms but ms can't see stuff in ps.  Which is the point here.  
 ; 
  (setq cspac (wasp))
  (cond ((= cspac 1)
         (prompt "*** You must be in Paper Space. ***")
         (exit))
        ((= cspac 3)
         (prompt "*** Switching to Paper Space. ***\n")
         (command "pspace")))
 ; Ŀ
 ;   Unlock the viewports, also just in case.                              
 ; 
  (command ".mview" "L" "off" "all" "")
 ; Ŀ
 ;   Get two points.                                                       
 ; 
  (setq pa (getpoint "Base Point: "))
  (setq pb (getpoint pa "\nSecond Point: "))
 ; Ŀ
 ;   Now translate the points into model space.                            
 ;   Must switch to model space before doing the trans so that it will     
 ;   know that the current viewport is ms and not ps.                      
 ;   Apparently there can be a paper space ucs, but this isn't allowed     
 ;   for here - the world coordinate system is assumed to be active.       
 ; 
  (command "mspace")
  (setq pa (trans (trans pa 3 2) 2 0))
  (setq pb (trans (trans pb 3 2) 2 0))
  (command "pan" pa pb)
 ; Ŀ
 ;   Lock the viewports again.                                             
 ; 
  (command ".mview" "L" "on" "all" "")
 ; Ŀ
 ;   And get back into the appropriate space ... actually there is only    
 ;   one condition here that requires a change, sice we are in ms.         
 ; 
  (if (= cspac 1)
      (command "pspace"))
  (command "undo" "end")
 (princ))